<%@ Page Title="Lab Result Details" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabResultDetails.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabResultDetails" MaintainScrollPositionOnPostback = "true" ValidateRequest="false" %>

<%@ Register src="~/Controls/Custom/EFR/BioLabResultUserControl.ascx" tagname="BioLabResultUserControl" tagprefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">         
    <style type="text/css">
        .style1
        {
            width: 7%;
        }
        .style2
        {
            width: 25%;
        }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <%--<script src="scripts/jquery.json-2.2.js" type="text/javascript"></script>--%>
    <script src="../../../Scripts/Custom/EFR/jquery.json-2.2.js" type="text/javascript"></script>
    <script type = "text/javascript">

        $(document).ready(function()
        {
            if ($('select.AnalyteNameList').find(":selected").val() == 15)
            {
                $('div.otherAnalyteName').show();
                ValidatorEnable($("[id*=OtherAnalyteValidator]")[0], true);
            }
            else
            {
                $('div.otherAnalyteName').hide();
                $("input[id*='OtherAnalyteBox']").val('');
                ValidatorEnable($("[id*=OtherAnalyteValidator]")[0], false);
            }

            if ($('select.AnalysisMethodList').find(":selected").val() == 7)
            {
                $('div.otherAnalysisMethod').show();
                ValidatorEnable($("[id*=OtherAnalysisMethodValidator]")[0], true);
            }
            else
            {
                $('div.otherAnalysisMethod').hide();
                $("input[id*='OtherAnalysisMethodBox']").val('');
                ValidatorEnable($("[id*=OtherAnalysisMethodValidator]")[0], false);
            }

            $('select.AnalyteNameList').change(function(e)
            {
                if ($(this).find(":selected").val() == 15)
                {
                    $('div.otherAnalyteName').fadeIn(1000);

                    ValidatorEnable($("[id*=OtherAnalyteValidator]")[0], true);
                    var validator = $("[id*=OtherAnalyteValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);

                    $("input[id*='OtherAnalyteBox']").focus();
                }
                else
                {
                    $('div.otherAnalyteName').fadeOut(1000);
                    $("input[id*='OtherAnalyteBox']").val('');
                    ValidatorEnable($("[id*=OtherAnalyteValidator]")[0], false);
                }

                if ($(this).val() != 0 && $('select.TestNameList').val() != 0)
                {
                    var params = new Object();
                    params.testId = $('select.TestNameList').val();
                    params.analyteId = $(this).val();

                    $.ajax(
                    {
                        type: "POST",
                        data: $.toJSON(params),
                        dataType: "json",
                        contentType: "application/json",
                        url: "../WebService/ReferenceRangeTestUnits.asmx/GetUnitAndReferenceRange",
                        success: function(response)
                        {
                            $('select.UnitNameList').val(response.d.UnitId);
                        }

                    });
                }
                else
                {
                    $('select.UnitNameList').val(0);
                }
            }).keydown(function() { $(this).change(); });

            $('select.AnalysisMethodList').change(function(e)
            {
                if ($(this).find(":selected").val() == 7)
                {
                    $('div.otherAnalysisMethod').fadeIn(1000);
                    ValidatorEnable($("[id*=OtherAnalysisMethodValidator]")[0], true);
                    var validator = $("[id*=OtherAnalysisMethodValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);
                }
                else
                {
                    $('div.otherAnalysisMethod').fadeOut(1000);
                    $("input[id*='OtherAnalysisMethodBox']").val('');
                    ValidatorEnable($("[id*=OtherAnalysisMethodValidator]")[0], false);
                }
            });

            $('.ResultCommentBox input:checkbox').click(function()
            {
                if ($(this).is(':checked'))
                {
                    $(this).closest('td').find('input:text').attr('disabled', 'disabled');
                    $(this).closest('td').find('input:text').val('');

                    ValidatorEnable($("[id*=AnalysisResultBoxRequiredValidator]")[0], false);

                    var validator = $("[id*=AnalysisResultBoxRequiredValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);

                    ValidatorEnable($("[id*=UnitNameListRequiredValidator]")[0], false);

                    $("input[id*='CommentBox']").val('< LOD*');

                }
                else
                {
                    $(this).closest('td').find('input:text').removeAttr('disabled');
                    ValidatorEnable($("[id*=AnalysisResultBoxRequiredValidator]")[0], true);
                    var validator = $("[id*=AnalysisResultBoxRequiredValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);

                    ValidatorEnable($("[id*=UnitNameListRequiredValidator]")[0], true);
                    var validator = $("[id*=UnitNameListRequiredValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);


                    $("input[id*='CommentBox']").val('');
                }

                $(this).focus();
            });


            $("input[id*='ReferenceRangeBox']").blur(function()
            {
                if ($(this).val() != "")
                {
                    ValidatorEnable($("[id*=ReferenceRangeListRequiredValidator]")[0], true);
                    var validator = $("[id*=ReferenceRangeListRequiredValidator]")[0];
                    validator.isvalid = true;
                    ValidatorUpdateDisplay(validator);
                }
                else
                {
                    ValidatorEnable($("[id*=ReferenceRangeListRequiredValidator]")[0], false);
                }
            });

            if ($("input[id*='ReferenceRangeBox']").val() != "")
            {
                ValidatorEnable($("[id*=ReferenceRangeListRequiredValidator]")[0], true);
                var validator = $("[id*=ReferenceRangeListRequiredValidator]")[0];
                validator.isvalid = true;
                ValidatorUpdateDisplay(validator);
            }
            else
            {
                ValidatorEnable($("[id*=ReferenceRangeListRequiredValidator]")[0], false);
            }

            var analyteNames = $('select.AnalyteNameList').html();

            //pre-select items on dependent dropdown
            switch ($('select.TestNameList').val())
            {
                //CONCENTRATION                                                     
                case "4":

                    $('select.AnalyteNameList option').filter(function()
                    {
                        return ($(this).val() == 16);

                    }).remove();

                    break;

                case "6":

                    $('select.AnalyteNameList option').filter(function()
                    {
                        return ($(this).val() == 16);

                    }).remove();

                    break;

                case "7":

                    $('select.AnalyteNameList option').filter(function()
                    {
                        return !($(this).val() == 16 || $(this).val() == 0);

                    }).remove();

                    $('select.AnalyteNameList').val('16');

                    break;

                case "8":

                    $('select.AnalyteNameList option').filter(function()
                    {
                        return !($(this).val() == 16 || $(this).val() == 0);

                    }).remove();

                    $('select.AnalyteNameList').val('16');
                    break;

                case "9":

                    $('select.AnalyteNameList option').filter(function()
                    {
                        return !($(this).val() == 12 || $(this).val() == 0);

                    }).remove();


                    $('select.AnalyteNameList').val('12');

                    break;

                default:

            }

            $('select.TestNameList').change(function(e)
            {

                $('select.AnalyteNameList').html(analyteNames);

                switch ($(this).val())
                {
                    //CONCENTRATION                                                     
                    case "4":

                        $('select.AnalyteNameList option').filter(function()
                        {
                            return ($(this).val() == 16);

                        }).remove();

                        break;

                    case "6":

                        $('select.AnalyteNameList option').filter(function()
                        {
                            return ($(this).val() == 16);

                        }).remove();

                        break;

                    case "7":

                        $('select.AnalyteNameList option').filter(function()
                        {
                            return !($(this).val() == 16 || $(this).val() == 0);

                        }).remove();

                        $('select.AnalyteNameList').val('16');

                        break;

                    case "8":

                        $('select.AnalyteNameList option').filter(function()
                        {
                            return !($(this).val() == 16 || $(this).val() == 0);

                        }).remove();

                        $('select.AnalyteNameList').val('16');

                        break;

                    case "9":

                        $('select.AnalyteNameList option').filter(function()
                        {
                            return !($(this).val() == 12 || $(this).val() == 0);

                        }).remove();


                        $('select.AnalyteNameList').val('12');

                        break;

                    default:
                }

                $('div.otherAnalyteName').hide();
                $("input[id*='OtherAnalyteBox']").val('');

                if ($(this).val() != 0 && $('select.AnalyteNameList').val() != 0)
                {
                    var params = new Object();
                    params.testId = $(this).val();
                    params.analyteId = $('select.AnalyteNameList').val();

                    $.ajax(
                    {
                        type: "POST",
                        data: $.toJSON(params),
                        dataType: "json",
                        contentType: "application/json",
                        url: "../WebService/ReferenceRangeTestUnits.asmx/GetUnitAndReferenceRange",
                        success: function(response)
                        {
                            $('select.UnitNameList').val(response.d.UnitId);
                        }

                    });
                }
                else
                {
                    $('select.UnitNameList').val(0);
                }

            });

            if ($('#<%= dataListViewAddModeFlag.ClientID %>').val() == '1')
            {
                $('select.TestNameList:first').focus();
                $('#<%= dataListViewAddModeFlag.ClientID %>').val('0');
            }


            if ($('#<%= dataListViewEditModeFlag.ClientID %>').val() == '1')
            {
                $('select.TestNameList:first').focus();
                $('#<%= dataListViewEditModeFlag.ClientID %>').val('0');
            }

            $('[id*=ButtonEdit]').click(function()
            {
                $('#<%= dataListViewEditModeFlag.ClientID %>').val('1');
            });

            $('[id*=ButtonUpdate]').click(function()
            {
                $('#<%= dataListViewEditModeFlag.ClientID %>').val('0');

            });

            $('[id*=ButtonCancel]').click(function()
            {
                $('#<%= dataListViewEditModeFlag.ClientID %>').val('0');

            });

            $('[id*=ButtonDelete]').click(function()
            {
                alert("Test Result will be deleted.");
            });

        });
    </script>

    <asp:ObjectDataSource ID="ObjectDataSourceTests" runat="server" OnSelecting="Ds_Selecting"
        SelectMethod="GetTestNameList" 
        TypeName="VIRP_WEB.BaseCode.EfrInterfaceManager">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceAnalyteNames" runat="server" OnSelecting="Ds_Selecting"
        SelectMethod="GetBiomonitoringAnalytes" 
        TypeName="VIRP_WEB.BaseCode.EfrInterfaceManager">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceAnalysisMethods" runat="server" OnSelecting="Ds_Selecting"
        SelectMethod="GetBiomonitoringAnalysisMethods" 
        TypeName="VIRP_WEB.BaseCode.EfrInterfaceManager">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceTestUnits" runat="server" OnSelecting="Ds_Selecting"
        SelectMethod="GetBiomionitoringTestUnits" 
        TypeName="VIRP_WEB.BaseCode.EfrInterfaceManager">
    </asp:ObjectDataSource>
    <asp:ValidationSummary ID="ValidationSummaryLabResultDetails" runat="server" 
        HeaderText="The page has the following data errors:" 
        EnableClientScript="true"
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="BioLabResults"
        ShowMessageBox="True" />
    <asp:ValidationSummary ID="ValidationSummaryAnalyteEdit" runat="server" 
        HeaderText="The page has the following data errors:" 
        EnableClientScript="true"
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="AnalyteGroup"
        ShowMessageBox="True" />
    <asp:ValidationSummary ID="ValidationSummary1" runat="server" 
        HeaderText="The page has the following data errors:" 
        EnableClientScript="true"
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="AnalyteGroupAdd"
        ShowMessageBox="True" />
        
        
     <uc1:BioLabResultUserControl ID="BioLabResultUserControl1" runat="server" LabReportDateIsReadOnly="false" />
    
     
     <asp:Panel ID="Panel1" runat="server" Width="99%" GroupingText="Lab Tests">
        <table  summary="Table is used for layout purposes" width="70%">
            <tr>
                <td>
                    <asp:Label SkinID="DataLabel" ID="Label2" runat="server" 
                        AssociatedControlID="txtElapsedTime" Width="110px">Elapsed Time(hours):</asp:Label>
                   <asp:TextBox ID = "txtElapsedTime" runat = "server"></asp:TextBox>
                </td>
                <td >
                    <asp:Label SkinID="DataLabel" ID="Label6" runat="server" AssociatedControlID="txtTotalVolume">Total Volume(ml):</asp:Label>
                    <asp:TextBox ID = "txtTotalVolume" runat = "server"></asp:TextBox>
                    <asp:CompareValidator ID="TotalVolumeValidator" Operator = "DataTypeCheck" Type = "Double" 
                   ControlToValidate = "txtTotalVolume" runat = "server" Display = "Dynamic" SetFocusOnError = "true" 
                   EnableClientScript = "true" ErrorMessage = "Invalid Total Volume" ValidationGroup = "BioLabResults"></asp:CompareValidator>     
                </td>
                <td>
                    <asp:Label SkinID="DataLabel" ID="Label9" runat="server" AssociatedControlID="txtVolOfAnalyteTests">Volume of Analyte Tests(ml):</asp:Label>
                    <asp:TextBox ID = "txtVolOfAnalyteTests" runat = "server"></asp:TextBox>
                    <asp:CompareValidator ID="VolumeOfAnalyteTestsValidator" Operator = "DataTypeCheck" Type = "Double" 
                   ControlToValidate = "txtVolOfAnalyteTests" runat = "server" Display = "Dynamic" SetFocusOnError = "true" 
                   EnableClientScript = "true" ErrorMessage = "Invalid Volume of Analyte Tests" ValidationGroup = "BioLabResults"></asp:CompareValidator>    
                </td>
            </tr>
        </table>
         <br />
        <%-- <asp:Repeater ID="AnalyteRepeater" runat="server" >--%>
        
         <asp:HiddenField ID="dataListViewEditModeFlag" runat = "server" value="0" />
         <asp:HiddenField ID="dataListViewAddModeFlag" runat = "server" value="0" />
        <asp:DataList ID="AnalyteList" runat="server" Width = "100%"
        DataKeyField = "ANALYSIS_DETAIL_ID" OnEditCommand="AnalyteList_EditCommand"
        OnCancelCommand = "AnalyteList_CancelCommand" OnUpdateCommand = "AnalyteList_UpdateCommand" 
        OnDeleteCommand = "AnalyteList_DeleteCommand" OnItemDataBound = "AnalyteList_DataBound" 
        OnItemCommand = "AnalyteList_ItemCommand" OnPreRender = "AnalyteList_PreRender" UseAccessibleHeader = "true" >
                     
             <HeaderTemplate>
                <table width="100%"  cellspacing="-2" cellpadding="2">
                <tr bgcolor="#1E2D54" style="color:White">
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>Test Name</th>
                    <th>Analyte Name</th>
                    <th>Analysis Method</th>
                    <th>Result</th>
                    <th>Unit</th>
                    <th>Lab Reference Range</th>
                    <th>Reference Range Unit</th>
                    <th>Above Lab Reference Range</th>
                </tr>
            </HeaderTemplate>
            
            
            <ItemTemplate>
                <tr>
                    <td style = "width:70px" valign = "middle" align = "center" rowspan = "3">
                        <asp:Button ID = "ButtonEdit" runat = "server" Text = "&nbsp;Edit&nbsp;" CommandName = "Edit" CommandArgument = '<%# Container.ItemIndex %>' Width = "60px" />
                    </td>
                    <td style = "width:70px" valign = "middle" align = "center" rowspan = "3" >
                        <asp:Button ID = "ButtonDelete" runat = "server" Text = "&nbsp;Delete&nbsp;" CommandName = "Delete" Width = "60px" />  
                    </td>
                    <td><asp:Label SkinID="DataLabel" ID = "LabTestNameLabel" runat = "server">
                    <b><%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("TEST_NAME")))%></b></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "AnalyteNameLabel" runat = "server">
                    <b><%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ANALYTE_NAME")))%></b></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "AnalysisMethodLabel" runat = "server">
                    <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ANALYSIS_METHOD_NAME")))%></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "ResultTextLabel" runat = "server">
                    <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("RESULT_TEXT")))%></asp:Label></td>
                    <td style = "width:100px" align = "left">
                        <asp:Label SkinID="DataLabel" ID = "Unit2NameLabel" runat = "server">
                        <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STD_UNIT2.NAME")))%></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "ReferenceRangeLabel" runat = "server">
                    <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_REFERENCE_RANGE")))%></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "UnitNameLabel" runat = "server">
                    <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STD_UNIT.NAME"))) %></asp:Label></td>
                    <td><asp:Label SkinID="DataLabel" ID = "AboveReferenceRangeLabel" runat = "server">
                    <%# Eval("LAB_ABOVE_REFERENCE_RANGE") != null ? Eval("LAB_ABOVE_REFERENCE_RANGE").ToString() == "1" ? "Yes" : "No" : String.Empty%></asp:Label></td>
                </tr>
                <tr>
                    <td colspan="7">
                    <asp:Label SkinID="DataLabel" ID = "CommentsTextLabel" runat = "server">
                    <%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("EVAL_COMMENT_TEXT")))%></asp:Label></td>
                    
                </tr>
                <tr>
                    <td align="left" colspan="7">
                    <asp:Label SkinID="DataLabel" ID = "LabelForOtherComments" runat = "server"
                     AssociatedControlID="LabelOtherComments" >Comments:&nbsp;</asp:Label>
                    <asp:Label SkinID="DataLabel" ID = "LabelOtherComments" runat = "server"><%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("OTHER_COMMENT_TEXT")))%></asp:Label></td>    
                 </tr>
            </ItemTemplate>
            <EditItemTemplate>
            
                <tr>
                   
                    <td style = "width:70px" valign = "middle" align = "center" rowspan = "3">
                        
                            <asp:Button ID = "ButtonUpdate" runat = "server" Text = "&nbsp;Update&nbsp;" CommandName = "Update" ValidationGroup = "AnalyteGroup"/>
                         
                    </td>
                    <td style = "width:70px" valign = "middle" align = "center" rowspan = "3">
                            <asp:Button ID = "ButtonCancel" runat = "server" Text = "&nbsp;Back&nbsp;" CommandName = "Cancel" />     
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID = "TestNameLabel" runat = "server" Text = "Test Name *:" AssociatedControlID = "TestNameList"></asp:Label>
                        <br />
                        <asp:DropDownList ID = "TestNameList" runat = "server"
                        CssClass = "TestNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTests" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                            
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="TestNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TestNameList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroup"
                            ErrorMessage="Test Name is required.">
                         </asp:RequiredFieldValidator> 
                    </td>
                    <td align = "left" style ="width:175px" >     
                        <asp:Label SkinID="DataLabel" ID = "AnalyteNameLabel" runat = "server" Text = "Analyte Name *:" AssociatedControlID = "AnalyteNameList"></asp:Label>
                        <br />
                         <asp:DropDownList ID = "AnalyteNameList" runat = "server" 
                         CssClass = "AnalyteNameList"
                            AppendDataBoundItems="true" DataSourceID="ObjectDataSourceAnalyteNames" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="AnalyteNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="AnalyteNameList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroup"
                            ErrorMessage="Analyte Name is required.">
                         </asp:RequiredFieldValidator> 
                        <br />
                         <div class = "otherAnalyteName" style = "display:none;width:100%;overflow:hidden" >                        
                            <asp:Label SkinID="DataLabel" ID = "OtherAnalyteLabel" runat = "server" Text = "Other Analyte, Specify:" AssociatedControlID = "OtherAnalyteBox"></asp:Label> 
                            <br />
                            <asp:TextBox ID = "OtherAnalyteBox" runat = "server" Width = "95%"></asp:TextBox>
                            
                          <asp:RequiredFieldValidator ID = "OtherAnalyteValidator" runat = "server" ControlToValidate = "OtherAnalyteBox"
                            Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                            ErrorMessage = "Please enter analyte name" ValidationGroup = "AnalyteGroup"></asp:RequiredFieldValidator> 
                           
                    </td>
                    <td align = "left" style = "width:225px" >
                        <asp:Label SkinID="DataLabel" ID = "AnalysisMethodLabel" runat = "server" Text = "Analysis Method:" AssociatedControlID = "AnalysisMethodList"></asp:Label>
                        <br />    
                        <asp:DropDownList ID = "AnalysisMethodList" runat = "server"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceAnalysisMethods"
                            CssClass = "AnalysisMethodList" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                        </asp:DropDownList>
                        <br />
                        <br />
                            <div class = "otherAnalysisMethod" style = "display:none;width:100%;overflow:hidden">    
                                <asp:Label SkinID="DataLabel" ID = "OtherAnalysisMethodLabel" runat = "server" Text = "Other Analysis Method, Specify:" AssociatedControlID = "OtherAnalysisMethodBox"></asp:Label> 
                                <br />
                                <asp:TextBox ID = "OtherAnalysisMethodBox" runat = "server" Width = "95%"></asp:TextBox>
                                
                                <asp:RequiredFieldValidator ID = "OtherAnalysisMethodValidator" runat = "server" ControlToValidate = "OtherAnalysisMethodBox"
                                Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                                ErrorMessage = "Please enter analysis method" ValidationGroup = "AnalyteGroup"></asp:RequiredFieldValidator>    
                            </div> 
                    </td>
                    <td align = "left">
                        <asp:Label SkinID="DataLabel" ID = "AnalysisResultLabel" runat = "server" Text = "Result *:" AssociatedControlID = "AnalysisResultBox"></asp:Label> 
                        <br />
                        <asp:TextBox ID = "AnalysisResultBox" runat = "server"></asp:TextBox>
                        <asp:RequiredFieldValidator ID = "AnalysisResultBoxRequiredValidator" runat = "server" ControlToValidate = "AnalysisResultBox"
                            Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                            ErrorMessage = "Please enter results or check comment checkbox." ValidationGroup = "AnalyteGroup"></asp:RequiredFieldValidator> 
                        <br />
                        <br />
                        <asp:CheckBox ID = "ResultCommentCheck" runat = "server" Text = "Comment" BorderWidth = "0" CssClass = "ResultCommentBox" /> 
                         
                    </td>
                    <td style="width:100px" align = "left">
                        <asp:Label SkinID="DataLabel" ID = "LabelForAnalyteUnitLabel" runat = "server" Text = "Unit *:" AssociatedControlID = "UnitList"></asp:Label> 
                        <br />                       
                        
                       <asp:DropDownList ID = "UnitList" runat = "server"
                        CssClass = "UnitNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTestUnits" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select Unit)">
                            </asp:ListItem>
                            
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="UnitNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="UnitList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroup"
                            ErrorMessage="Unit is required.">
                         </asp:RequiredFieldValidator> 
                                                                           
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID = "ReferenceRangeLabel" runat = "server" Text = "Lab Reference Range:" AssociatedControlID = "ReferenceRangeBox"></asp:Label> 
                        <br />
                        <asp:TextBox ID = "ReferenceRangeBox" runat = "server"></asp:TextBox>
                        <br />
                        <br />
                        
                    </td>
                    <td align = "left">
                        <asp:Label SkinID="DataLabel" ID = "LabelForReferenceRangeUnitBox" runat = "server" Text = "Reference Range Unit:" AssociatedControlID = "ReferenceRangeUnitList"></asp:Label> 
                        <br />
                        <asp:DropDownList ID = "ReferenceRangeUnitList" runat = "server"
                        CssClass = "UnitNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTestUnits" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select Unit)">
                            </asp:ListItem>
                            
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="ReferenceRangeListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="ReferenceRangeUnitList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroup"
                            ErrorMessage="Unit is required.">
                         </asp:RequiredFieldValidator> 
                                      
                    </td>                    
                    <td valign = "middle">
                        <asp:CheckBox Text = "Above Lab Reference Range" ID = "AboveReferenceCheck" runat = "server" /> 
                    
                    </td>
                    
                    
                                                          
                </tr>                
                <tr>
                    <td colspan = "7">
                        <asp:Label SkinID="DataLabel" ID = "EvaluationNoteLabel" runat = "server" Text = "Evaluation Note:" AssociatedControlID = "EvaluationNoteBox"></asp:Label>
                        <br />
                        <asp:TextBox TextMode = "MultiLine" ID = "EvaluationNoteBox" runat = "server" Width = "99%" Height = "60px"></asp:TextBox>   
                    </td>               
                </tr>
                <tr>
                    <td colspan = "7">
                        <asp:Label SkinID="DataLabel" ID = "CommentLabel" runat = "server" Text = "Comment:" AssociatedControlID = "CommentBox"></asp:Label>
                        <br />
                        <asp:TextBox ID = "CommentBox" runat = "server" Width = "99%"></asp:TextBox>   
                    </td>
                
                </tr>
                <tr>
                    <td colspan = "2">
                        &nbsp;
                    </td>
                    <td colspan="5">
                        <asp:Label runat="server" SkinID="DataLabel" ID="AnalyteEditRequiredFieldIndicator">* Field is required to edit an analyte.</asp:Label>
                    </td>
                </tr>                                         
            </EditItemTemplate> 
            <SeparatorTemplate>
            <tr>
                <td colspan="10">
                    <hr style = "color:Black" /> 
                </td>
            </tr>
            </SeparatorTemplate>
            
            <FooterTemplate>
            <tr>
                <td colspan="10">
                    <hr style = "color:Black" /> 
                </td>
            </tr>
            
            <tr>
                              
                    <td style = "width:60px" valign = "middle" align = "center" rowspan = "3">
                        
                        &nbsp;
                         
                    </td>
                    <td style = "width:60px" valign = "middle" align = "center" rowspan = "3">
                    
                        &nbsp; 
                    
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID = "TestNameLabel" runat = "server" Text = "Test Name *:" AssociatedControlID = "TestNameList"></asp:Label>
                        <br />
                        <asp:DropDownList ID = "TestNameList" runat = "server"
                        CssClass = "TestNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTests" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="TestNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TestNameList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroupAdd"
                            ErrorMessage="Test Name is required.">
                         </asp:RequiredFieldValidator>
                                                 
                    </td>
                    <td align = "left" style ="width:175px">     
                        <asp:Label SkinID="DataLabel" ID = "AnalyteNameLabel" runat = "server" Text = "Analyte Name *:" AssociatedControlID = "AnalyteNameList"></asp:Label>
                        <br />
                         <asp:DropDownList ID = "AnalyteNameList" runat = "server" 
                         CssClass = "AnalyteNameList"
                            AppendDataBoundItems="true" DataSourceID="ObjectDataSourceAnalyteNames" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                        </asp:DropDownList>
                        <br />
                            <asp:RequiredFieldValidator ID="AnalyteNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="AnalyteNameList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroupAdd"
                            ErrorMessage="Analyte Name is required.">
                         </asp:RequiredFieldValidator> 
                        <br />
                            <div class = "otherAnalyteName" style = "display:none;width:100%;overflow:hidden">                        
                                <asp:Label SkinID="DataLabel" ID = "OtherAnalyteLabel" runat = "server" Text = "Other Analyte, Specify:" AssociatedControlID = "OtherAnalyteBox"></asp:Label> 
                                <br />
                                <asp:TextBox ID = "OtherAnalyteBox" runat = "server" Width = "90%"></asp:TextBox>
                                <asp:RequiredFieldValidator ID = "OtherAnalyteValidator" runat = "server" ControlToValidate = "OtherAnalyteBox"
                                Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                                ErrorMessage = "Please enter analyte name" ValidationGroup = "AnalyteGroupAdd"></asp:RequiredFieldValidator>
                            </div> 
                                                  
                    </td>
                    <td align = "left" style ="width:225px">
                        <asp:Label SkinID="DataLabel" ID = "AnalysisMethodLabel" runat = "server" Text = "Analysis Method:" AssociatedControlID = "AnalysisMethodList"></asp:Label>
                        <br />    
                        <asp:DropDownList ID = "AnalysisMethodList" runat = "server"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceAnalysisMethods"
                            CssClass = "AnalysisMethodList" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select a Value)">
                            </asp:ListItem>
                        </asp:DropDownList>
                        <br />
                        <br />
                            <div class = "otherAnalysisMethod" style = "display:none;width:100%;overflow:hidden">  
                                <asp:Label SkinID="DataLabel" ID = "OtherAnalysisMethodLabel" runat = "server" Text = "Other Analysis Method, Specify:" AssociatedControlID = "OtherAnalysisMethodBox"></asp:Label> 
                                <br />
                                <asp:TextBox ID = "OtherAnalysisMethodBox" runat = "server" Width = "90%"></asp:TextBox>
                                <asp:RequiredFieldValidator ID = "OtherAnalysisMethodValidator" runat = "server" ControlToValidate = "OtherAnalysisMethodBox"
                                Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                                ErrorMessage = "Please enter analysis method" ValidationGroup = "AnalyteGroupAdd"></asp:RequiredFieldValidator>
                            </div> 
                    </td>
                    <td align = "left">
                        <asp:Label SkinID="DataLabel" ID = "AnalysisResultLabel" runat = "server" Text = "Result *:" AssociatedControlID = "AnalysisResultBox"></asp:Label> 
                        <br />
                        <asp:TextBox ID = "AnalysisResultBox" runat = "server"></asp:TextBox>
                        <asp:RequiredFieldValidator ID = "AnalysisResultBoxRequiredValidator" runat = "server" ControlToValidate = "AnalysisResultBox"
                            Display = "Dynamic" EnableClientScript = "true" SetFocusOnError = "true" 
                            ErrorMessage = "Please enter results or check comment checkbox." ValidationGroup = "AnalyteGroupAdd"></asp:RequiredFieldValidator> 
                        <br />
                        <br />
                        <asp:CheckBox ID = "ResultCommentCheck" runat = "server" Text = "Comment" BorderWidth = "0" CssClass = "ResultCommentBox" /> 
                         
                    </td>
                    <td style = "width:100px" align= "left">
                        <asp:Label SkinID="DataLabel" ID = "LabelForAnalyteUnitLabel" runat = "server" Text = "Unit:" AssociatedControlID = "UnitList"></asp:Label> 
                        <br />
                                               
                       <asp:DropDownList ID = "UnitList" runat = "server"
                        CssClass = "UnitNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTestUnits" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select Unit)">
                            </asp:ListItem>
                            
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="UnitNameListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="UnitList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroupAdd"
                            ErrorMessage="Unit is required.">
                         </asp:RequiredFieldValidator> 
                                                                           
                    </td>
                          
                    
                    <td>
                        <asp:Label SkinID="DataLabel" ID = "ReferenceRangeLabel" runat = "server" Text = "Lab Reference Range:" AssociatedControlID = "ReferenceRangeBox"></asp:Label> 
                        <br />
                        <asp:TextBox ID = "ReferenceRangeBox" runat = "server"></asp:TextBox> 
                        <br />
                        <br />
                    </td>
                    
                    <td>
                        <asp:Label SkinID="DataLabel" ID = "LabelForReferenceRangeUnitBox" runat = "server" Text = "Reference Range Unit:" AssociatedControlID = "ReferenceRangeUnitList"></asp:Label> 
                        <br />
                        <asp:DropDownList ID = "ReferenceRangeUnitList" runat = "server"
                        CssClass = "UnitNameList"
                        AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTestUnits" 
                            DataTextField="NAME" 
                            DataValueField="ID">
                            <asp:ListItem Value="0" Text = "(Select Unit)">
                            </asp:ListItem>
                            
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="ReferenceRangeListRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="ReferenceRangeUnitList"                                                                 
                            InitialValue="0"
                            ValidationGroup = "AnalyteGroupAdd"
                            ErrorMessage="Unit is required.">
                         </asp:RequiredFieldValidator> 
                                      
                    </td>       
                    
                    <td valign = "middle">
                        <asp:CheckBox Text = "Above Lab Reference Range" ID = "AboveReferenceCheck" runat = "server" /> 
                    
                    </td>
                                                          
                </tr>                
                <tr>
                    <td colspan = "8">
                        <asp:Label SkinID="DataLabel" ID = "EvaluationNoteLabel" runat = "server" Text = "Evaluation Note:" AssociatedControlID = "EvaluationNoteBox"></asp:Label>
                        <br />
                        <asp:TextBox TextMode = "MultiLine" ID = "EvaluationNoteBox" runat = "server" Width = "99%" Height = "60px"></asp:TextBox>   
                    </td>               
                </tr>
                <tr>
                    <td colspan = "8">
                        <asp:Label SkinID="DataLabel" ID = "CommentLabel" runat = "server" Text = "Comment:" AssociatedControlID = "CommentBox"></asp:Label>
                        <br />
                        <asp:TextBox ID = "CommentBox" runat = "server" Width = "99%"></asp:TextBox>   
                    </td>
                
                </tr>        
            
                       
            <tr>
                <td colspan="10">
                    <hr style = "color:Black" /> 
                </td>
            </tr>
            <tr>
                <td align = "left" colspan = "2" >
                    &nbsp;
                </td> 
            
           
                <td align = "left" colspan = "8">
                    <asp:Button ID = "ButtonNewAnalyte" runat = "server" Text = "Add Analyte" CommandName = "Insert" ValidationGroup = "AnalyteGroupAdd"  /> 
                    <br />
                    
                </td>           
            </tr>
            <tr>
                <td colspan = "2">
                        &nbsp;
                    </td>
                <td colspan="8">
                    <asp:Label runat="server" SkinID="DataLabel" ID="AnalyteRequiredFieldIndicator">* Field is required to add an analyte.</asp:Label>
                </td>            
            </tr>
                        
            </table> 
        </FooterTemplate>
       
         </asp:DataList> 
    </asp:Panel>
    
    <asp:Panel ID="Panel2" GroupingText="&nbsp;" style="width:100%;" runat="server" Font-Bold="true">
        <table><tr><td>
        
        <asp:Button runat = "server" ID = "btnSave" Text = "Save"
            OnClick = "BtnSave_Click" Width = "100px" ValidationGroup = "BioLabResults" />
        <asp:Button runat="server" ID="btnReject" Text = "Void" Width = "100px" 
            onclick="BtnReject_Click" OnClientClick="return confirm('This will void this lab result. Do you want to proceed?');"/> 
        <asp:Button runat="server" ID="btnAccept" Text = "Accept"   
                onclick="BtnAccept_Click" Width = "100px" ValidationGroup = "BioLabResults"
                OnClientClick="return confirm('Please note that after pressing the Accept button this record will become static (non-editable). Are you sure that you want to accept this lab result?');" />
        
        <asp:Button runat="server" ID="btnCancel" Text = "Back" Width = "100px" 
                onclick="BtnCancel_Click" UseSubmitBehavior = "false" CssClass = "cancel" />
                
        </td><td align="center">&nbsp;&nbsp;&nbsp;<b><asp:HyperLink runat="server" Visible = "false" Text="Go to Associated Lab Order" NavigateUrl = "" ID= "LabOrderLink"></asp:HyperLink></b></td></tr></table>
    </asp:Panel>
    <asp:Label SkinID="DataLabel" runat="server" ID="lblDuplicateConfirmation" Font-Bold="true" ForeColor="Red" Visible="false" Text="This lab result cannot be accepted, because this case already has another accepted lab result." Font-Size="Medium"></asp:Label>    
</asp:Content>

